package com.ejie.p06b.manager;

import java.util.Date;
import java.util.List;
import java.util.Locale;

import com.ejie.p06b.dao.P06BA1T00DAO;
import com.ejie.p06b.datatype.logic.P06BNumeracionesComp;
import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;

/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * 
 * Manager para pruebas unitarias y de desarrollo de la aplicacin
 * Centralizacin de Test
 * 
 * Fecha de creacin: (09/05/07)
 */
public class P06BTestManager {
	
	static private P06BTestManager instance = null;

	public static P06BTestManager getInstance() {
	     if (instance == null) {
	          synchronized (P06BTestManager.class) {
	          		if (instance == null) {
	                     instance = new P06BTestManager();
	                }
	          }
	     }
	     return instance;
	}
	
	/**
    * Obtiene todos los registros BD ordenandolos por codigo
    * 
    * @return List - ArrayList
    * @throws P06BException
    */
	public List selectAll() throws P06BException{
		List result = null;
		try {
			result = P06BA1T00DAO.getInstance().selectAll();
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BTestManager - selectAll: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);

		}
		return result;
	}
	
	/**
    * Obtiene un registro de la BD a partir del cdigo y le aade la fecha actual
    * y una descripcion de su nombre de clase
    * 
    * @param codigo 
    * 			Elemento que deseamos obtener
    * @param idioma 
    * 			Necesario para formatear la fecha de forma correcta
    * 
    * @return un objeto P06BNumeracionesComp
    * @throws P06BException
    */
	public P06BNumeracionesComp select(String codigo, String idioma) throws P06BException{
		P06BNumeracionesComp result = new P06BNumeracionesComp();
		try {
			result.setNumeracion(P06BA1T00DAO.getInstance().select(codigo));
			result.setFecha(P06BFecha.getFechaFormateada(new Date(), new Locale(idioma, idioma)));
			result.setDescripcion(this.getClass().toString());
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BTestManager - select: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);

		}
		return result;
	}
	
	/**
    * Obtiene un registro de la BD a partir del cdigo y le aade la fecha actual
    * y una descripcion de su nombre de clase
    * 
    * @param codigo 
    * 			Elemento que deseamos obtener
    * @param idioma 
    * 			Necesario para formatear la fecha de forma correcta
    * 
    * @throws P06BException
    */
	public void insertAndDelete(P06BNumeracionesComp obj, boolean conError) throws P06BException{
		try {
			P06BA1T00DAO.getInstance().insert(obj.getNumeracion());
			if(conError)
				Integer.parseInt("Prueba Forzada");
			P06BA1T00DAO.getInstance().delete(obj.getNumeracion().getCodigo());
		} catch (Exception e) {
			P06BLog.send(0,this,"P06BTestManager - insertAndDelete: "+e.getMessage());
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0002);
		}
	}

}
